#include	"site/Sky_basic.h"

#include	"dimensions/Temperature.h"
#include	"transport/Irradiance.h"
#include	"site/Sky_irradiance.h"
#include	"site/Sky_temperature.h"

Type*	Sky_basic_Type_pointer;
static	char*	class_name = "the_sky(basic)";


Sky_basic::Sky_basic(Metaclass* meta, Sky_basic_def* def)
						: Sky(meta, (Sky_def*)def)
{
	DEBUG << "Sky_basic::Sky_basic(" << meta->oid() ", " << def->oid() ")\n";

	name(class_name);			// assumes only one sky object
	directType(TYPE_OF(Sky_basic));

	the_sky_irradiance_theory = INSTANTIATE(Sky_irradiance,
						def->sky_irradiance_def());
	the_sky_temperature_theory = INSTANTIATE(Sky_temperature,
						 def->sky_temperature_def());
}

Sky_basic::Sky_basic(Sky_basic& s)  : Sky((Sky&)s)
{
	DEBUG << "Sky_basic::Sky_basic(" << s->oid() ")\n";

					// NB user will have to set new  name
	directType(TYPE_OF(Sky_basic));

	the_sky_irradiance_theory = s.the_sky_irradiance_theory;
	the_sky_temperature_theory = s.the_sky_temperature_theory;
}

Sky_basic::Sky_basic(APL* theAPL) : Sky(theAPL)
{
	RETRIEVE(the_sky_irradiance_theory);
	RETRIEVE(the_sky_temperature_theory);
};

Sky_basic::~Sky_basic()
{
	DEBUG << "Sky_basic::~Sky_basic()\n";

	Destroy(FALSE);
};

void	Sky_basic::Destroy(Boolean aborted)
{
	DEBUG << "Sky_basic::Destroy(Boolean aborted)\n";

	DELETE(Sky_irradiance, the_sky_irradiance_theory);
	DELETE(Sky_temperature, the_sky_temperature_theory);

	if (aborted)
		Sky::Destroy(aborted);
};

void	Sky_basic::putObject(Boolean deallocate)
{
	DEBUG << "Sky_basic::putObject(Boolean deallocate)\n";

	STORE(the_sky_irradiance_theory);
	STORE(the_sky_temperature_theory);

	Sky::putObject(deallocate);
};

void	Sky_basic::deleteObject(Boolean deallocate)
{
	DEBUG << "Sky_basic::deleteObject(Boolean deallocate)\n";

	FORGET(the_sky_irradiance_theory);
	FORGET(the_sky_temperature_theory);

	Sky::deleteObject(deallocate);
};


Sky_basic& Sky_basic::operator=(Sky_basic& s)
{
	DEBUG1 << "Sky_basic::operator=(" << s->oid() ")\n";

	if (this==&s) return *this;

	(void) Sky::operator=((Sky&)s);
	the_sky_irradiance_theory = s.the_sky_irradiance_theory;
	the_sky_temperature_theory = s.the_sky_temperature_theory;

	return *this;
};

Irradiance Sky_basic::irradiance(Irradiance& augmented_irradiance,
			   Sun_position& a_sun_pos,
			   Orientation& a_surface_orientation,
			   Time_of_day& a_time_of_day)
{
	DEBUG1 << "Sky_basic::irradiance(" << augmented_irradiance << ", Sun_position&,";
	DEBUG1 << " Orientation&, " << a_time_of_day << ")\n";

	return sky_irradiance()->execute(augmented_irradiance, a_sun_pos,
					 a_surface_orientation, a_time_of_day);
}

Temperature Sky_basic::temperature(ClimateRecord& a_clm_rec,
			     Sun_position& a_sun_pos,
			     Time_of_day& a_time_of_day)
{
	DEBUG1 << "Sky_basic::temperature(ClimateRecord&, " << a_sun_pos  << ", ";
	DEBUG1 << a_time_of_day << ")\n";

	return sky_temperature()->execute(a_clm_rec, a_sun_pos, a_time_of_day);
}
