#include	"site/Site_sun_def.h"

#include	<stdlib.h>
#include	"transport/Location.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Sun_basic_def.h"
#include	"site/Sky_basic_def.h"
#include	"site/Climate_def.h"

Type*	Site_sun_def_Type_pointer;
static	char*	class_name = "the_site_sun_def";


Site_sun_def::Site_sun_def(Metaclass* meta)  : Site_basic_def(meta)
{
	DEBUG	<< "Site_sun_def::Site_sun_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Site_sun_def));

	the_sun = meta->make_def_for("Sun");
	the_sky = meta->make_def_for("Sky");

};

Site_sun_def::Site_sun_def(char* site_name, Location* location,
			   Climate_met_def* a_climate_def, Sun_basic_def* a_sun_def,
			   Sky_basic_def* a_sky_def)
			: Site_basic_def(site_name, location, a_climate_def)
{
	DEBUG	<< "Site_sun_def(" << site_name << ", " << location->oid() <<", ";
	DEBUG	<< a_climate_def->oid() << "," << a_sun_def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Site_sun_def));

	the_sun = a_sun_def;
	the_sky = a_sky_def;
};

Site_sun_def::Site_sun_def(APL* theAPL) : Site_basic_def(theAPL)
{};


Sun_basic_def*	Site_sun_def::sun_def()
{
	DEBUG1	<< "Site_sun_def::sun_def()\n";

	return (Sun_basic_def*)the_sun;
};

Sky_basic_def*	Site_sun_def::sky_def()
{
	DEBUG1	<< "Site_sun_def::sky_def()\n";

	return (Sky_basic_def*)the_sky;
};


void	Site_sun_def::description(Metaclass* meta, ostream& s)
{
	s << "Site_sun : ";
	Site_basic_def::description(meta, s);
	s << "->  Sun = ";
	strcat(indent,"    ");
	meta->describe_def_for("Sun", s);
	indent[strlen(indent)-4] = '\0';
	s << "->  Sky = ";
	indent[strlen(indent)-4] = ' ';
	meta->describe_def_for("Sky", s);
	indent[strlen(indent)-4] = '\0';
};
