#ifndef SITE_SUN_H
#define SITE_SUN_H

#include	"site/Site_basic.h"
#include	"site/Site_sun_def.h"
class	Sun_basic;
class	Sky_basic;

extern	Type*	Site_sun_Type_pointer;


class Site_sun : public Site_basic {
protected:
	Sun_basic*	the_sun;			// a Sun_basic or derived
	Sky_basic*	the_sky;			// a Sky_basic or derived
public:
	Site_sun(Metaclass* meta, Site_sun_def* def);
	Site_sun(Site_sun& s);
	Site_sun(APL* theAPL);
	~Site_sun();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Site_sun& 	operator=(Site_sun& s);
#undef sun
//	Sun_basic*	sun();
	Sun_basic*	ssun();
	Sky_basic*	sky();

	virtual	ClimateRegime climateRegime(Time_of_day& a_time);
};


inline
Type*	Site_sun::getDirectType()
{
	return TYPE_OF(Site_sun);
};

//inline
//Sun_basic*	Site_sun::sun()
//{						// cast guaranteed by Metaclasses
//	return (Sun_basic*)the_sun;
//};

inline
Sun_basic*	Site_sun::ssun()
{						// cast guaranteed by Metaclasses
	return (Sun_basic*)the_sun;
};

inline
Sky_basic*	Site_sun::sky()
{					// casts guaranteed by Metaclasses
	return (Sky_basic*)the_sky;
};

#endif
