#include	"site/Site_sun.h"

#include	"transport/ClimateRecord.h"
#include	"transport/ClimateRegime.h"
#include	"transport/Sun_position.h"
#include	"transport/Orientation.h"
#include	"transport/Irradiance.h"
#include	"site/Sun_basic.h"
#include	"site/Sky_basic.h"
#include	"site/Climate_met.h"

Type*	Site_sun_Type_pointer;
static	char*	class_name = "the_site(sun_sky)";


Site_sun::Site_sun(Metaclass* meta, Site_sun_def* def)
				: Site_basic(meta, (Site_basic_def*)def)
{
	DEBUG	<< "Site_sun::Site_sun(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);		// assume only 1 site object
	directType(TYPE_OF(Site_sun));
					// make a Sun_basic or derived
	the_sun = INSTANTIATE(Sun_basic, def->sun_def());
					// make a Sky_basic or derived
	the_sky = INSTANTIATE(Sky_basic, def->sky_def());
};

Site_sun::Site_sun(Site_sun& s)
				: Site_basic((Site_basic&)s)
{
	DEBUG << "Site_sun::Site_sun(" << s.oid() << ")\n";

	directType(TYPE_OF(Site_sun));

	the_sun = s.the_sun;
	the_sky = s.the_sky;
}

Site_sun::Site_sun(APL* theAPL) : Site_basic(theAPL)
{
	RETRIEVE(the_sun);
	RETRIEVE(the_sky);
};

Site_sun::~Site_sun()
{
	DEBUG << "Site_sun::~Site_sun()\n";

	Destroy(FALSE);
};

void	Site_sun::Destroy(Boolean aborted)
{
	DEBUG << "Site_sun::Destroy(Boolean aborted)\n";

	DELETE(Sun, the_sun);
	DELETE(Sky, the_sky);

	if (aborted)
		Site_basic::Destroy(aborted);
};

void	Site_sun::putObject(Boolean deallocate)
{
	DEBUG << "Site_sun::putObject(Boolean deallocate)\n";

	STORE(the_sun);
	STORE(the_sky);

	Site_basic::putObject(deallocate);
};

void	Site_sun::deleteObject(Boolean deallocate)
{
	DEBUG << "Site_sun::deleteObject(Boolean deallocate)\n";

	FORGET(the_sun);
	FORGET(the_sky);

	Site_basic::deleteObject(deallocate);
};

Site_sun& Site_sun::operator=(Site_sun& s)
{
	DEBUG1 << "Site_sun::operator=(" << s.oid() << ")\n";

	if(this==&s) return *this;

	Site::operator=((Site&)s);
	the_sun = s.the_sun;
	the_sky = s.the_sky;

	return *this;
};

ClimateRegime Site_sun::climateRegime(Time_of_day& a_time)
{
	DEBUG1 << "Site_sun::climateRegime(" << time << ")\n";

	ClimateRecord	clmset = climate()->climateRecord(a_time);

	Temperature	temperature_dry = clmset.dryBulb();
	Temperature	temperature_wet = clmset.wetBulb();
	Proportion	relative_humidity =
			(temperature_dry - temperature_wet)/temperature_dry;
	Speed		wind_speed = clmset.windSpeed();
	Angle		wind_direction = clmset.windDirection();

				/* Get sky irradiance on vert surface.*/
	Sun_position	sun_position = ssun()->position(the_site_location, a_time);

	Energy	dirNor = clmset.directNormalSolar();
	Energy	difHor = clmset.diffuseHorizontalSolar();
	Orientation	clm_orientation(0.0, 90.0, 0.0);
	Sun_position	clm_sunpos = ssun()->position(climate()->location(),
						     a_time);
	Irradiance aug_irradiance(dirNor,difHor,clm_orientation,clm_sunpos);

	// Calculate the solar angle of incidence on a vertical
	// south facing surface.  Multi-surface reference case
	// to be added in future.
	Orientation south_vertical(180.0,0.0,0.0);
	Orientation north_vertical(0.0,0.0,0.0);
	Orientation west_vertical(270.0,0.0,0.0);
	Orientation east_vertical(90.0,0.0,0.0);
	Orientation flat_roof(0.0,90.0,0.0);

	// Calculate the sky irradiance on reference surface
	// and add to the irradiance list.  This irradiance list
	// will be deleted by going out of scope at the end of
	// the program.
	List(Irradiance) irradiance_list;
	Irradiance south_irradiance = sky()->irradiance(
		aug_irradiance, sun_position, south_vertical,
		a_time);
	irradiance_list.append(&south_irradiance);

	Irradiance north_irradiance = sky()->irradiance(
		aug_irradiance, sun_position, north_vertical,
		a_time);
	irradiance_list.append(&north_irradiance);

	Irradiance west_irradiance = sky()->irradiance(
		aug_irradiance, sun_position, west_vertical,
		a_time);
	irradiance_list.append(&west_irradiance);

	Irradiance east_irradiance = sky()->irradiance(
		aug_irradiance, sun_position, east_vertical,
		a_time);
	irradiance_list.append(&east_irradiance);

	Irradiance flat_roof_irradiance = sky()->irradiance(
		aug_irradiance, sun_position, flat_roof,
		a_time);
	irradiance_list.append(&flat_roof_irradiance);

	return ClimateRegime(temperature_dry, wind_speed, wind_direction,
			     relative_humidity, &irradiance_list);
};
