#include	"site/Site_basic_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"transport/Location.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Climate_met_def.h"

Type*	Site_basic_def_Type_pointer;
static	char*	class_name = "the site_basic_def";


Site_basic_def::Site_basic_def(Metaclass* meta)  : Site_def(meta)
{
	DEBUG	<< "Site_basic_def::Site_basic_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Site_basic_def));

	climate = meta->make_def_for("Climate");
};

Site_basic_def::Site_basic_def(char* site_name,Location* location, Climate_met_def* a_climate_def)
					: Site_def(site_name, location)
{
	DEBUG	<< "Site_basic_def::Site_basic_def(" << site_name << ", " << location->name();
	DEBUG	<< ", " << a_climate_def->name() << ")\n";

	name(class_name);
	directType(TYPE_OF(Site_basic_def));

	climate = a_climate_def;
};

Site_basic_def::Site_basic_def(APL* theAPL) : Site_def(theAPL)
{};

Site_basic_def::~Site_basic_def()
{
	DEBUG << "Site_basic_def::~Site_basic_def()\n";
};



Climate_met_def*	Site_basic_def::climate_def()
{
	DEBUG1	<< "Site_def::climate_def()\n";

	return (Climate_met_def*)climate;
};


void	Site_basic_def::description(Metaclass* meta, ostream& s)
{
	s << "Site_basic\n";
	s << indent << "site_name:\n";
	s << indent << "site_location: \n";
	s << indent << "->  Climate = ";
	strcat(indent,"    ");
	meta->describe_def_for("Climate", s);
	indent[strlen(indent)-4] = '\0';
};
