#ifndef SITE_BASIC_H
#define SITE_BASIC_H

#include	"site/Site.h"
#include	"site/Site_basic_def.h"
class	Climate_met;

extern	Type*	Site_basic_Type_pointer;


class Site_basic : public Site {
protected:
	Climate_met*	the_climate;		// a Climate_met or derived
public:
	Site_basic(Metaclass* meta, Site_basic_def* def);
	Site_basic(Site_basic& s);
	Site_basic(APL* theAPL);
	~Site_basic();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Site_basic& operator=(Site_basic& s);

	Climate_met*	climate();

	virtual	ClimateRegime	climateRegime(Time_of_day& a_time);
};


inline
Type*	Site_basic::getDirectType()
{
	return TYPE_OF(Site_basic);
};

inline
Climate_met*	Site_basic::climate()
{						// cast guaranteed by Metaclass
	return (Climate_met*)the_climate;
};

#endif
