#include	"site/Site_basic.h"

#include	<string.h>
#include	"transport/ClimateRegime.h"
#include	"transport/ClimateRecord.h"
#include	"transport/Time_of_day.h"
#include	"site/Climate_met.h"

Type*	Site_basic_Type_pointer;
static	char*	class_name = "the_site(basic)";


Site_basic::Site_basic(Metaclass* meta, Site_basic_def* def)
				: Site(meta, (Site_def*) def)
{
	DEBUG	<< "Site_basic::Site_basic(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);			// assumes only one site object
	directType(TYPE_OF(Site_basic));

					// make a Climate_met or derived
	the_climate = INSTANTIATE(Climate_met, def->climate_def());
};

Site_basic::Site_basic(Site_basic& s)  : Site((Site&)s)
{
	DEBUG << "Site_basic::Site_basic(" << s.oid() << ")\n";

	directType(TYPE_OF(Site_basic));

	the_climate = s.the_climate;
}

Site_basic::Site_basic(APL* theAPL) : Site(theAPL)
{
	RETRIEVE(the_climate);
};

Site_basic::~Site_basic()
{
	DEBUG << "Site_basic::~Site_basic()\n";

	Destroy(FALSE);
};

void	Site_basic::Destroy(Boolean aborted)
{
	DEBUG << "Site_basic::Destroy(Boolean aborted)\n";

	DELETE(Climate_met, the_climate);

	if (aborted)
		Site::Destroy(aborted);
};

void	Site_basic::putObject(Boolean deallocate)
{
	DEBUG << "Site_basic::putObject(Boolean deallocate)\n";

	STORE(the_climate);

	Site::putObject(deallocate);
};

void	Site_basic::deleteObject(Boolean deallocate)
{
	DEBUG << "Site_basic::deleteObject(Boolean deallocate)\n";

	FORGET(the_climate);

	Site::deleteObject(deallocate);
};


Site_basic& Site_basic::operator=(Site_basic& s)
{
	DEBUG1 << "Site_basic& Site_basic::operator=(" << s.oid() << ")\n";

	if(this==&s) return *this;

	(void) Site::operator=((Site&)s);
	the_climate = s.the_climate;

	return *this;
};

ClimateRegime Site_basic::climateRegime(Time_of_day& a_time)
{
	DEBUG1 << "Site::climateRegime(" << a_time << ")\n";

	ClimateRecord	clmset = climate()->climateRecord(a_time);

	Temperature	temperature_dry = clmset.dryBulb();
	Temperature	temperature_wet = clmset.wetBulb();
	Proportion	relative_humidity =
			(temperature_dry - temperature_wet)/temperature_dry;
	Speed		wind_speed = clmset.windSpeed();
	Angle		wind_direction = clmset.windDirection();

	return ClimateRegime(temperature_dry, wind_speed, wind_direction,
		 	     relative_humidity, NULLPTR(List(Irradiance)));
};
