#ifndef PEREZ_H
#define PEREZ_H

#include	"site/Sky_irradiance.h"
#include	"site/Perez_def.h"

extern	Type*	Perez_Type_pointer;

/*
** Establish the solar intensity values.  The circumsolar
** component is established from a formula by Perez.
** This is then subtracted from the diffuse horizontal value
** and added to the direct normal value.
*/


class Perez : public Sky_irradiance {
protected:
	float	EPSINT[8];
	float	F11ACC[8];
	float	F12ACC[8];
	float	F13ACC[8];
	float	F21ACC[8];
	float	F22ACC[8];
	float	F23ACC[8];

	void initialise_coefficients();
public:
	Perez(Metaclass* meta, Perez_def* def);
	Perez(Perez& k);
	Perez(Sky_irradiance& k);
	Perez(APL* theAPL);

	Type*	getDirectType();

	Perez& operator=(Sky_irradiance& k);
	Perez& operator=(Perez& k);

virtual	Irradiance execute(Irradiance& augmented_irradiance,
			   Sun_position& a_sun_pos,
			   Orientation& a_surface_orientation,
			   Time_of_day& a_time_of_day);
};


inline
Type*	Perez::getDirectType()
{
	return TYPE_OF(Perez);
};

#endif
