#include	"site/Perez.h"

#include	<math.h>
#include	"transport/Irradiance.h"
#include	"transport/Time_of_day.h"

Type*	Perez_Type_pointer;
static	char*	class_name = "the_sky_irradiance(Perez)";


void Perez::initialise_coefficients()
{
	/* Coefficients required for the Perez algorithm. */
	EPSINT[0]=1.056;
	EPSINT[1]=1.253;
	EPSINT[2]=1.586;
	EPSINT[3]=2.134;
	EPSINT[4]=3.230;
	EPSINT[5]=5.980;
	EPSINT[6]=10.080;
	EPSINT[7]=999999;
	F11ACC[0]=-.011;
	F11ACC[1]=-0.038;
	F11ACC[2]=.166;
	F11ACC[3]=.419;
	F11ACC[4]=.710;
	F11ACC[5]=.857;
	F11ACC[6]=0.734;
	F11ACC[7]=0.421;
	F12ACC[0]=.748;
	F12ACC[1]=1.115;
	F12ACC[2]=.909;
	F12ACC[3]=.646;
	F12ACC[4]=.025;
	F12ACC[5]=-.370;
	F12ACC[6]=-0.073;
	F12ACC[7]=-0.661;
	F13ACC[0]=-.080;
	F13ACC[1]=-0.109;
	F13ACC[2]=-.179;
	F13ACC[3]=-.262;
	F13ACC[4]=-.290;
	F13ACC[5]=-.279;
	F13ACC[6]=-0.228;
	F13ACC[7]=0.097;
	F21ACC[0]=-.048;
	F21ACC[1]=-0.023;
	F21ACC[2]=.062;
	F21ACC[3]=.140;
	F21ACC[4]=.243;
	F21ACC[5]=.267;
	F21ACC[6]=0.231;
	F21ACC[7]=0.119;
	F22ACC[0]=.073;
	F22ACC[1]=0.106;
	F22ACC[2]=-.021;
	F22ACC[3]=-.167;
	F22ACC[4]=-.511;
	F22ACC[5]=-.792;
	F22ACC[6]=-1.180;
	F22ACC[7]=-2.125;
	F23ACC[0]=-.024;
	F23ACC[1]=-0.037;
	F23ACC[2]=-.050;
	F23ACC[3]=-.042;
	F23ACC[4]=-.004;
	F23ACC[5]=.076;
	F23ACC[6]=0.199;
	F23ACC[7]=0.446;
}


Perez::Perez(Metaclass* meta, Perez_def* def)
				: Sky_irradiance(meta, (Sky_irradiance_def*)def)
{
	DEBUG << "Perez::Perez()\n";

	name(class_name);			// assume only 1 sky irradiance
	directType(TYPE_OF(Perez));

	/* Coefficients required for the Perez algorithm. */
	initialise_coefficients();
}

Perez::Perez(Perez& k) : Sky_irradiance((Sky_irradiance&)k)
{
	DEBUG << "Perez::Perez(Perez& s)\n";

					// NB user will have to set new name
	directType(TYPE_OF(Perez));

	/* Coefficients required for the Perez algorithm. */
	initialise_coefficients();
}

Perez::Perez(Sky_irradiance& k) : Sky_irradiance((Sky_irradiance&)k)
{
	DEBUG << "Perez::Perez(Sky_irradiance& s)\n";

	name(class_name);
	directType(TYPE_OF(Perez));

	/* Coefficients required for the Perez algorithm. */
	initialise_coefficients();
}

Perez::Perez(APL* theAPL) : Sky_irradiance(theAPL)
{};


Perez& Perez::operator=(Sky_irradiance& k)
{
	DEBUG1 << "Perez::operator=(Sky_irradiance&)\n";
	if(this==&k) return *this;

	/* Copy the Sky_irradiance part. */
	(void) Sky_irradiance::operator=(k);
	/* Initialise the Perez part (there is nothing to copy). */
	initialise_coefficients();
	return *this;
}

Perez& Perez::operator=(Perez& k)
{
	DEBUG1 << "Perez::operator=(Perez&)\n";
	if(this==&k) return *this;

	/* Copy the Sky_irradiance part. */
	(void) Sky_irradiance::operator=((Sky_irradiance&)k);
	/* Copy the Perez part. */
	initialise_coefficients();
	return *this;
}


/*
** Calculates the direct and sky diffuse components incident
** on an inclined surface.
** Note: At the moment, the variables plane_elevation,
** cosine of the angle of incidence are passed not pointers
** to the objects which may contain such information.
*/
Irradiance Perez::execute(Irradiance& augmented_irradiance,
			   Sun_position& a_sun_pos,
			   Orientation& a_surface_orientation,
			   Time_of_day& a_time_of_day)
{
	DEBUG1 << "Irradiance Perez::execute(Irradiance& augmented_irradiance, Sun_position& a_sun_pos,\n";
	DEBUG1 << "Orientation& a_surface_orientation, Time_of_day& a_time_of_day))\n";

	float QF=augmented_irradiance.diffuse().value();
	float QD=augmented_irradiance.direct().value();
	float SALT=a_sun_pos.elevation();
	float PELV=a_surface_orientation.elevation();	////????
	float CAI=cos(a_surface_orientation.azimuth());	////????
	int IDYP=a_time_of_day.day();			////????
	float R = PI / 180.;
	float BETA=90.0-PELV;


/* alpha = the half-angle circumsolar region.
   hpmalf, hppalf are help variables.
   beta = the inclination angle of the surface (defined above).
   teta = incident angle on the tilted surface
   zet = solar zenith angle (pi/2 - solar altitude). */
	float HP = 0.5 * PI;
	float ALPHA = 25. * R;
	float HPMALF = HP - ALPHA;
	float HPPALF = HP + ALPHA;
	float TETA = acos(CAI);
	float ZET = acos(sin(SALT*R));

/* Calculation of the relative air mass. */
	float AIRM  = 1. / sin(SALT * R);
	if(SALT < 10.0) AIRM = 1.0 / (sin(SALT*R)
		+ 0.15 * pow((SALT + 3.885),(-1.253)));

/* Calculation of the extraterrestrial radiation. */
	float G0N = 1370. * (1. + 0.033 * cos(0.017214 * IDYP));

/* The sky diffuse component: */

/* Calculation of PSIC and PSIH (for XIC, XIH). */

	float PSIC = ((HPPALF - TETA) / ALPHA) / 2.;
	float PSIH = 1.;
	if (ZET > HPMALF) PSIH = (HPPALF - ZET)/ALPHA*2.;

/* Calculation of XIC and XIH (for A en C). */

	float XIC = 0.0;
	if ((TETA > HPMALF) && (TETA < HPPALF))
		XIC = PSIH * PSIC * sin(PSIC * ALPHA);
	if (TETA < HPMALF) XIC = PSIH * CAI;
	float XIH = PSIH * sin(PSIH * ALPHA);
	if (ZET < HPMALF) XIH = cos(ZET);

/* Approximation of A and C, the solid angles occupied by the
   circumsolar region, weighted by its average incidence on the
   slope and horizontal respectively. In the expression of SKYDIF
   the quotient of A/C is reduced to XIC/XIH.
   A = 2. * (1. - cos(ALPHA)) * XIC
   C = 2. * (1. - cos(ALPHA)) * XIH */

/* Determination of INTEPS with EPS ("sky clearness parameter"). */
	float EPS;
	if (QF > 0.) EPS = (QF + QD) / QF;
	else EPS = 0.;

	int INTEPS;
	int a_flag=0;
	for(int i=0;i<8 && a_flag==0;i++) {
		if (EPS <= EPSINT[i]) {
			INTEPS = i;
			a_flag=1;
		}
	}

/* DELTA is "the new sky brightness parameter". */
	float DELTA = QF * AIRM / G0N;

/* Determination of the "new circumsolar brightness coefficient
   (F1ACC) and horizon brightness coefficient (F2ACC)". */

	float F1ACC = F11ACC[INTEPS] + F12ACC[INTEPS] * DELTA
		+ F13ACC[INTEPS] * ZET;
	float F2ACC = F21ACC[INTEPS] + F22ACC[INTEPS] * DELTA
		+ F23ACC[INTEPS] * ZET;

/* Determination of the diffuse radiation on an inclined surface. */

	float SKYDIF = QF * ( 0.5 * (1. + cos(BETA*R)) * (1. - F1ACC)
		+ F1ACC * XIC/XIH + F2ACC * sin(BETA*R));

	if (SKYDIF < 0.) SKYDIF = 0.0;

/* Horizontal surfaces treated separately
   beta = 0   : surface facing up
   beta = 180 : surface facing down. */
	if ((BETA > -0.01) && (BETA < 0.01)) SKYDIF = QF;
	if ((BETA > 179.99) && (BETA < 180.01)) SKYDIF = 0;

/* Direct solar radiation incident normally on
   external construction prior to shading adjustment
   and absorption. */
	float SRADDO=QD*CAI;
	if ( SRADDO < 0.0 ) SRADDO = 0.0;

/* Not calculating the ground diffuse. */
	return Irradiance(Energy(SRADDO), Energy(SKYDIF), a_surface_orientation, a_sun_pos);
}
