#ifndef CLIMATE_MET_H
#define CLIMATE_MET_H

#include	"transport/Location.h"
#include	"transport/ClimateSet.h"
#include	"transport/ClimateRecord.h"
#include	"site/Climate.h"
#include	"site/Climate_met_def.h"
class	Time_of_day;

extern Type*	Climate_met_Type_pointer;


class Climate_met : public Climate {
protected:
	char*		the_climate_name;
	ClimateSet*	the_climate;
public:
	Climate_met(Metaclass* meta, Climate_met_def* def);
	Climate_met(Climate_met& clm);
	Climate_met(APL* theAPL);
	~Climate_met();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	Type*	getDirectType();

virtual	ClimateRecord	climateRecord(Time_of_day& time);
virtual	Location	location();
};


inline
Type*	Climate_met::getDirectType()
{
	return TYPE_OF(Climate_met);
};

inline
ClimateRecord	Climate_met::climateRecord(Time_of_day& time)
{
	DEBUG1	<< "Climate_met::clmset(" << time << ")\n";

	return the_climate->climateRecord(time);
};

inline
Location	Climate_met::location()
{
	DEBUG1	<< "Climate_met::location()\n";

	return the_climate->location();
};
#endif
