#include	"site/Climate_met.h"

#include	<string.h>
#include	<stdlib.h>
#include	"transport/ClimateSet.h"
#include	"transport/ClimateRecord.h"
#include	"transport/Profile.h"
#include	"transport/Time_of_day.h"
#include	"transport/Location.h"

Type*	Climate_met_Type_pointer;
static	char*	class_name = "the climate";


Climate_met::Climate_met(Metaclass* meta, Climate_met_def* def)
					: Climate(meta, (Climate_def*)def)
{
	DEBUG	<< "Climate_met::Climate_met(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name, def->climate_name());	// name contains clm set name
	directType(TYPE_OF(Climate_met));

	the_climate_name = strdup(def->climate_name());	// clm set name = filename
	the_climate = new ClimateSet(the_climate_name);
};


Climate_met::Climate_met(APL* theAPL) : Climate(theAPL)
{
	the_climate = new ClimateSet(the_climate_name);	// reread the climate set
};

Climate_met::~Climate_met()
{
	DEBUG << "Climate_met::~Climate_met()\n";

	Destroy(FALSE);
};

void	Climate_met::Destroy(Boolean aborted)
{
	DEBUG << "Climate_met::Destroy(Boolean aborted)\n";

	delete the_climate;
};

void	Climate_met::putObject(Boolean deallocate)
{
	DEBUG << "Climate_met::putObject(Boolean deallocate)\n";

// dont save climate cos then ClimateSet, Profile, etc would need to be persistent
// and I dont have time to sort it out now.  I do a reread in the APL ctor instead
	delete the_climate;
	Climate_met::putObject(deallocate);
};


