#ifndef ESYSTEM_H
#define ESYSTEM_H

#include "System.h"
#include "Equation_set.h"
#include "Component.h"
#include "EComponent.h"
#include "Connection.h"
#include "EConnection.h"
class Metaclass;
class ESystem_def;

template_declare(List,Component_def);
template_declare(List,Connection_def);
template_declare(List,Component);
template_declare(List,EComponent);
template_declare(List,Connection);
template_declare(List,EConnection);

class ESystem : public System {
private:
	Boolean		isin(EComponent* ap, List_iterator(EComponent)& lst);
protected:
	Equation_set	the_sys_eqset;
public:
	ESystem(Metaclass* meta, ESystem_def* def);
	~ESystem();

	void		delete_component();
	void		delete_connection();
	void		add_connection();
	void		add_component();
	void		list_components();
	void		list_connection();
virtual void		execute();
	Equation_set*	create_me();
	Equation_set*	equation_set() { return &the_sys_eqset; };
};
#endif

