#include "ESystem.h"
#include "ESystem_def.h"
#include "Metaclass.h"

//template_define(List,Component);
template_define(List,Connection);
template_define(List,EComponent);
template_define(List,EConnection);

static	char*	class_name = "the_esystem";
/**/static	char*	class_type = "ESystem";


Boolean	ESystem::isin(EComponent* ap, List_iterator(EComponent)& lst)
{
	EComponent*	ref;
	while (ref = lst(FORWARD))
		if (ap->pid()==BOUNDARY || ref==ap)
			return 1;
	return 0;
};

ESystem::ESystem(Metaclass* meta, ESystem_def* def)
				: (meta, (System_def*) def),
				  the_sys_eqset()
{
	DEBUG	<< "ESystem::ESystem(" << meta->oid() << ", " << def->oid() << ")\n";

	char* throwaway = class_name;
	my_type = class_type;
};

ESystem::~ESystem()
{
	DEBUG << "ESystem::~ESystem()\n";

};

/* Note:
** create_me() needs to be improved to calculate the system mass
** balance and passes the mass flow rate to the components which
** require these data to calculate the flow rate dependent nonlinear
** coefficients.
**
**	a_cmp->create_me(a_con, flow_rate1, flow_rate2);
*/
Equation_set*	ESystem::create_me()
{
	DEBUG1	<< "Equation_set*	ESystem::execute()\n";

	List(EConnection)&	con_list = *(List(EConnection)*)(&connections());
	List_iterator(EConnection)	icon_list(&con_list);

//	List(EComponent)	cmp_list = *(List(EComponent)*)(&components());
//	List_iterator(EComponent)	icmp_list(&cmp_list);

	List(EComponent)*	reference_cmp_list = NULLPTR(List(EComponent));
	List_iterator(EComponent) 	reference_cmp_list_iter(reference_cmp_list);

	((List(Equation)*)&the_sys_eqset)->clear();

	EConnection* a_con;
	while(a_con=icon_list(FORWARD)) {

		EComponent* a_cmp = (EComponent*)a_con->source();
		if (!isin(a_cmp, reference_cmp_list_iter)) {
			a_cmp->create_me(a_con);
			reference_cmp_list->append(a_cmp);
			the_sys_eqset += a_cmp->equation_set();
		}
		reference_cmp_list_iter(RESET);

		a_cmp = (EComponent*)a_con->target();
		if (!isin(a_cmp, reference_cmp_list_iter)) {
			a_cmp->create_me(a_con);
			reference_cmp_list->append(a_cmp);
			the_sys_eqset += a_cmp->equation_set();
		}
		reference_cmp_list_iter(RESET);

		a_con->connect();
	};
//	reference_cmp_list->clear();

	return &the_sys_eqset;
};

void	ESystem::execute()
{
	DEBUG1	<< "void	ESystem::execute()\n";

//	Equation_set* eqs = execute();
	the_sys_eqset = *(create_me());
}

//template_implement(List,Component);
//template_implement(List,Connection);
template_implement(List,EComponent);
template_implement(List,EConnection);
