#ifndef ECONNECTION_DEF_H
#define ECONNECTION_DEF_H

#include	"X_def.h"
#include	"Connection_def.h"

enum Connect_type { CONTACT, FLOW };

class EConnection_def : public Connection_def {
protected:
	int 		the_no_of_links;
	Connect_type*	the_link_id;
	Dimension*	the_link_coef;
	int*		the_link_src_loc;
	int*		the_link_tgt_loc;
public:
	EConnection_def(Metaclass* meta);
	~EConnection_def();

	int 		no_of_links()	{ return the_no_of_links; };
	Connect_type*	link_id()	{ return the_link_id; };
	Dimension*	link_coef()	{ return the_link_coef; };
	int*		link_pos_src()	{ return the_link_src_loc; };
	int*		link_pos_tgt()	{ return the_link_tgt_loc; };

static	void	description(Metaclass* meta, ostream& s);
};

#endif

