#ifndef ECONNECTION_H
#define ECONNECTION_H

#include 	"Connection.h"
#include	"EConnection_def.h"
class EConnection_def;
class EComponemt;
class Dimension;
class Temperature;
class Energy;
class Equation;
class State_variable;

class EConnection : public Connection {
private:
	void		modify_equation(Temperature ta, Dimension ha, Equation* eq);
	void		modify_equation(Energy q, Equation* eq);
	void		modify_equation(State_variable* sv, Dimension ha, Equation* eq);
protected:
	int 		the_no_of_links;
	Connect_type*	the_link_id;
	Dimension*	the_link_coef;
	int*		the_link_src_loc;
	int*		the_link_tgt_loc;
public:
	EConnection(Metaclass* meta, EConnection_def* def);
	EConnection& operator=(EConnection& conns);
	~EConnection();

	int 		no_of_links()	{ return the_no_of_links; };
	Connect_type*	link_id()	{ return the_link_id; };
	Dimension*	link_coef()	{ return the_link_coef; };
	int*		link_pos_src()	{ return the_link_src_loc; };
	int*		link_pos_tgt()	{ return the_link_tgt_loc; };

	void 		connect();
};

#endif
