#ifndef ECOMPONENT_H
#define ECOMPONENT_H

#include "Component.h"
#include "EComponent_def.h"
#include "Equation_set.h"
#include "Mixed_vector.h"

class		State_vector;
class		EComponent_def;
class		EConnection;

class EComponent : public Component {
protected:
	Position_id 	my_id;
	Equation_set	the_equation_set;
	Mixed_vector	the_excitations;
public:
	EComponent(Metaclass* meta, EComponent_def* def);
	~EComponent();

Equation_set&		equation_set();
Mixed_vector&		excitations();
Position_id		pid();

	int 		no_of_nodes();
//virtual	void		update(State_vector* a_state_vector);
	State_variable*	state_variable_of(Equation* a_equation);
	Equation*	equation_of(State_variable* a_state_variable);
virtual	void		create_me(EConnection* caller);

// the general form of the function may be needed in future
// to account for the flow dependent nonlinear coefficients.
//virtual void		create_me(EConnection* caller,
//				Mass_flow_rate flow1,
//				Mass_flow_rate flow2);
	
};

#endif
