#include "EComponent.h"

#include "Metaclass.h"

static	char*	class_name = "the_ecomponent";
static	char*	class_type = "EComponent";

EComponent::EComponent(Metaclass* meta, EComponent_def* def)
					: Component(meta, (Component_def*) def),
					the_equation_set(),
					the_excitations(0)
{
	DEBUG << "EComponent::EComponent(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	my_id = def->pid();
};

EComponent::~EComponent()
{
	DEBUG << "EComponent::~EComponent()\n";
};

Equation_set&	EComponent::equation_set()
{
	if(&the_equation_set == NULLPTR(Equation_set)) {
		cout <<"EComponent: attempt to extract the equations too soon.\n";
		cout <<"component not activated or not linked to the system.\n";
	}
	return the_equation_set;
};

Mixed_vector&	EComponent::excitations()
{
	if(&the_excitations == NULLPTR(Mixed_vector)) {
		cout <<"EComponent: attempt to extract the equations too soon.\n";
		cout <<"component not activated or not linked to the system.\n";
	}
	return the_excitations;
};

Position_id	EComponent::pid()
{
	return my_id;
};

int 		EComponent::no_of_nodes()
{
	DEBUG << "EComponent::no_of_equations()\n";

	return the_equation_set.size();
};

State_variable*	EComponent::state_variable_of(Equation* a_equation)
{
	DEBUG << "EComponent::state_variable_of(Equation* a_equation)\n";

	Equation* a = a_equation;		//do later
	return NULLPTR(State_variable);
};

Equation*	EComponent::equation_of(State_variable* a_state_variable)
{
	DEBUG << "EComponent::equation_of(State_variable* a_state_variable)\n";

	State_variable* a = a_state_variable;		//do later
	return NULLPTR(Equation);
};

void		EComponent::create_me(EConnection* caller)
{
	cout << "EComponent::create_me(EConnection* caller)\n";
};
