/*
    Generic type: Boundary excitations
    Type	: Single component
    Description	: supply excitations to internal components

    Node types
	node 1	- supplied at run time
	...
	node N - supplied at run time

   Connection conditions:
	types of node 1,2,...,N should be identical to the nodes of internal
	component(s) to be connected.
*/

#ifndef BOUNDARY_H
#define BOUNDARY_H

#include "EComponent.h"
class 	Boundary_def;

class Boundary : public EComponent {
protected:
	int	the_no_of_nodes;
	Variable_type*	the_excitation_type;
public:
	Boundary(Metaclass* meta, Boundary_def* def);
	~Boundary();

virtual	void		create_me(EConnection* caller);

};

#endif
