#include "Boundary.h"
#include "Metaclass.h"
#include "Boundary_def.h"

Boundary::Boundary(Metaclass* meta, Boundary_def* def) : (meta, (EComponent_def*)def)
{
	DEBUG << "Boundary::Boundary(" << meta->oid() << ", " << def->oid() << ")\n";

	the_no_of_nodes = def->no_of_nodes();
	the_excitation_type = def->excitation_type();
	
	the_excitations = def->vector();
};

Boundary::~Boundary()
{
	DEBUG << "Boundary::~Boundary()\n";
};

void		Boundary::create_me(EConnection* caller)
{
	DEBUG << "Boundary::create_me(EConnection* caller)\n";
	cout <<"I am a boundary, I have nothing to create.\n";

};

