#ifndef AC_MIXBOX_H
/*
    Generic type: AC mixbox
    Type	: Single component
    Description	: Air mixing box or converging junction ; 1 node model

    node types			excitation type		connection type
    	node 1	- air		      air		     flow	
*/

#define AC_MIXBOX_H

#include "EComponent.h"

#include "Ac_mixbox_def.h"

#include	"Substance.h"
#include	"SpecificHeatCapacity.h"
#include	"Mass_flow_rate.h"
class	Metaclass;
class	EConnection;

typedef	float	Heat_transfer_coeff;

class Ac_mixbox : public EComponent {
private:
	int	the_no_of_nodes;
	void	initialise();
protected:
	SpecificHeatCapacity	the_comp_specific_heat;
	Mass			the_total_mass;
	Substance		the_air;

public:
	Ac_mixbox(Metaclass* meta, Ac_mixbox_def* def);
	~Ac_mixbox();

virtual	void		create_me(EConnection* caller);
	void		create_me(Mass_flow_rate air_rate);

	SpecificHeatCapacity	comp_specific_heat();
	Mass			total_mass();
	Substance		air();
};

inline  SpecificHeatCapacity   Ac_mixbox::comp_specific_heat()
{
	return the_comp_specific_heat;
}

inline	Mass	Ac_mixbox::total_mass()
{
	return the_total_mass;
};

inline	Substance	Ac_mixbox::air()
{
	return the_air;
};

#endif
