#include "Ac_mixbox.h"

#include "EConnection.h"
#include "Metaclass.h"
#include "math.h"
#include "list.h"
#include "Temperature.h"
#include "Speed.h"

template_define(List,State_variable);

static	char*	class_name = "the_Ac_mixbox";
static	char*	class_type = "Ac_mixbox";

static	float	initial_temp[1] = { 20 };
static	List(State_variable)*	sv_list = new List(State_variable)();

void	Ac_mixbox::initialise()
{
		//initialise component system equation_set.
	for(int i=0; i<the_no_of_nodes; i++) {
		State_variable*	svp = new State_variable(this, initial_temp[i]);
		sv_list->append(svp);
	}
};

/*
			1 internal function
*/

Ac_mixbox::Ac_mixbox(Metaclass* meta, Ac_mixbox_def* def)
					: EComponent(meta, (EComponent_def*) def),
					the_air("air")
{
	DEBUG << "Ac_mixbox::Ac_mixbox(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_no_of_nodes = 1;

	the_comp_specific_heat	= def->comp_specific_heat();
	the_total_mass 		= def->total_mass();

	initialise();
};

Ac_mixbox::~Ac_mixbox()
{
	DEBUG << "Ac_mixbox::~Ac_mixbox()\n";
};

void		Ac_mixbox::create_me(EConnection* caller)
{
	DEBUG << "Ac_mixbox::create_me(EConnection* caller)\n";

	//	generate Mass_flow_rate for water and air and call
	//create_me(Mass_flow_rate air_rate);

};

void		Ac_mixbox::create_me(Mass_flow_rate air_rate)
{
	DEBUG << "Ac_mixbox::create_me(Mass_flow_rate air_rate)\n";

	List_iterator(State_variable)	state_variable(sv_list);
	Equation_iterator	ieq = equation_set().iterator();

	SpecificHeatCapacity	capacity[1];
	capacity[0] = (the_total_mass*the_comp_specific_heat);

		//flush old equations.
	Equation*	eqp;
	while (eqp = ieq(FORWARD)) delete eqp;

		//building up component equation.
	float coefficient = 0.0 ;
	eqp = new Equation(state_variable[0], ENERGY, - coefficient, 0, 0, capacity[0]);
	equation_set().append(eqp);
};
