#ifndef AC_FAN_DEF_H
#define AC_FAN_DEF_H

#include "EComponent_def.h"
#include "Mass.h"
#include "Volume_flow_rate.h"
#include "Power.h"
#include 	"SpecificHeatCapacity.h"
#include 	"NonDimensional.h"

class Ac_fan_def : public EComponent_def {
protected:
	SpecificHeatCapacity	the_comp_specific_heat;
	Mass			the_total_mass;
	Power			the_rated_absorbed_power;
	Volume_flow_rate	the_rated_volume_flow_rate;
	NonDimensional		the_overall_efficiency;

public:
	Ac_fan_def(Metaclass* meta);
	~Ac_fan_def();

	SpecificHeatCapacity	comp_specific_heat();
	Mass			total_mass();
	Power			rated_absorbed_power();
	Volume_flow_rate	rated_volume_flow_rate();
	NonDimensional		overall_efficiency();

static	void	description(Metaclass* meta, ostream& s);
};

inline  SpecificHeatCapacity   Ac_fan_def::comp_specific_heat()
{
	return the_comp_specific_heat;
}

inline	Mass	Ac_fan_def::total_mass()
{
	return the_total_mass;
};

inline Power	Ac_fan_def::rated_absorbed_power()
{
	return the_rated_absorbed_power;
}

inline Volume_flow_rate	Ac_fan_def::rated_volume_flow_rate()
{
	return the_rated_volume_flow_rate;
}

inline NonDimensional	Ac_fan_def::overall_efficiency()
{
	return the_overall_efficiency;
};

#endif
