/*
    Generic type: AC fan
    Type	: Single component
    Description	: Centrifugal fan ; 1 node model

    node types			excitation type		connection type
    	node 1	- air		      air		     flow	
*/
#ifndef AC_FAN_H
#define AC_FAN_H

#include "EComponent.h"

#include "Ac_fan_def.h"

#include	"Substance.h"
#include	"SpecificHeatCapacity.h"
#include	"Mass_flow_rate.h"
#include	"Volume_flow_rate.h"
#include 	"NonDimensional.h"
class	Metaclass;
class	EConnection;

typedef	float	Heat_transfer_coeff;


class Ac_fan : public EComponent {
private:
	int	the_no_of_nodes;
	void	initialise();
protected:
	
	SpecificHeatCapacity	the_comp_specific_heat;
	Mass			the_total_mass;
	Power			the_rated_absorbed_power;
	Volume_flow_rate	the_rated_volume_flow_rate;
	NonDimensional		the_overall_efficiency;
	Substance		the_air;
public:
	Ac_fan(Metaclass* meta, Ac_fan_def* def);
	~Ac_fan();

virtual	void		create_me(EConnection* caller);
	void		create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate);

	SpecificHeatCapacity	comp_specific_heat();
	Mass			total_mass();
	Power			rated_absorbed_power();
	Volume_flow_rate	rated_volume_flow_rate();
	NonDimensional	overall_efficiency();
	Substance		air();
};

inline  SpecificHeatCapacity   Ac_fan::comp_specific_heat()
{
	return the_comp_specific_heat;
}

inline	Mass	Ac_fan::total_mass()
{
	return the_total_mass;
};

inline Power	Ac_fan::rated_absorbed_power()
{
	return the_rated_absorbed_power;
}

inline Volume_flow_rate	Ac_fan::rated_volume_flow_rate()
{
	return the_rated_volume_flow_rate;
}

inline NonDimensional	Ac_fan::overall_efficiency()
{
	return the_overall_efficiency;
}

inline	Substance	Ac_fan::air()
{
	return the_air;
}

#endif
