#include "Ac_fan.h"

#include "EConnection.h"
#include "Metaclass.h"
#include "math.h"
#include "list.h"
#include "Temperature.h"
#include "Speed.h"
#include "Energy.h"

template_define(List,State_variable);

static	char*	class_name = "the_Ac_fan";
static	char*	class_type = "Ac_fan";

static	float	initial_temp[1] = { 20 };
static	List(State_variable)*	sv_list = new List(State_variable)();

void	Ac_fan::initialise()
{
		//initialise component system equation_set.
	for(int i=0; i<the_no_of_nodes; i++) {
		State_variable*	svp = new State_variable(this, initial_temp[i]);
		sv_list->append(svp);
	}
};

/*
			1 internal function
*/

Ac_fan::Ac_fan(Metaclass* meta, Ac_fan_def* def)
					: EComponent(meta, (EComponent_def*) def),
					the_air("air")
{
	DEBUG << "Ac_fan::Ac_fan(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_no_of_nodes = 1;

	the_comp_specific_heat		= def->comp_specific_heat();
	the_total_mass 			= def->total_mass();
	the_rated_absorbed_power	= def->rated_absorbed_power();
	the_rated_volume_flow_rate	= def->rated_volume_flow_rate();
	the_overall_efficiency		= def->overall_efficiency();

	initialise();
};

Ac_fan::~Ac_fan()
{
	DEBUG << "Ac_fan::~Ac_fan()\n";
};

void		Ac_fan::create_me(EConnection* caller)
{
	DEBUG << "Ac_fan::create_me(EConnection* caller)\n";

	//	generate Mass_flow_rate for water and air and call
	//create_me(Mass_flow_rate air_rate);

};

void		Ac_fan::create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate)
{
	DEBUG << "Ac_fan::create_me(Mass_flow_rate air_rate)\n";

	List_iterator(State_variable)	state_variable(sv_list);
	Equation_iterator	ieq = equation_set().iterator();

	SpecificHeatCapacity	capacity[1];
	capacity[0] = (the_total_mass*the_comp_specific_heat);

	float el = pow((air_rate/(air().density() * rated_volume_flow_rate())).value(), 3)* rated_absorbed_power().value();

		//flush old equations.
	Equation*	eqp;
	while (eqp = ieq(FORWARD)) delete eqp;
		//building up component equation.
	Energy qi(el);
	float coefficient = 0.0 ;
	eqp = new Equation(state_variable[0], ENERGY, - coefficient, qi, 0, capacity[0]);
	equation_set().append(eqp);
};
