#ifndef AC_DUCT_DEF_H
#define AC_DUCT_DEF_H

#include	"EComponent_def.h"
#include 	"Area.h"
#include 	"Mass.h"
#include	"Length.h"
#include 	"Mass_flow_rate.h"
#include 	"SpecificHeatCapacity.h"

class Ac_duct_def : public EComponent_def {
protected:
	SpecificHeatCapacity	the_comp_cp;
	Area		the_cs_face_area;
	Mass		the_total_mass;
	Length		the_duct_length;
	Length		the_duct_hydraulic_diameter;
public:
	Ac_duct_def(Metaclass* meta);
	~Ac_duct_def();

	SpecificHeatCapacity	comp_cp();
	Area		cs_face_area();
	Length		duct_length();
	Length		duct_hydraulic_diameter();
	Mass		total_mass();

static	void	description(Metaclass* meta, ostream& s);
};

inline  SpecificHeatCapacity   Ac_duct_def::comp_cp()
{
	return the_comp_cp;
}
inline	Area 	Ac_duct_def::cs_face_area()
{
	return the_cs_face_area;
};
inline	Length	Ac_duct_def::duct_length()
{
	return the_duct_length;
};

inline	Length 	Ac_duct_def::duct_hydraulic_diameter()
{
	return the_duct_hydraulic_diameter;
};

inline	Mass	Ac_duct_def::total_mass()
{
	return the_total_mass;
};

#endif
