/*
    Generic type: AC duct
    Type	: Single component
    Description	: 5 m length of air duct 125 mm; 1 node model

    node types			excitation type		connection type
    	node 1	- air		      air		     flow	
*/

#ifndef AC_DUCT_H
#define AC_DUCT_H

#include "EComponent.h"

#include "Ac_duct_def.h"

#include	"Substance.h"
#include	"SpecificHeatCapacity.h"
class	Metaclass;
class	EConnection;

typedef	float	Heat_transfer_coeff;

class Ac_duct : public EComponent {
private:
	int	the_no_of_nodes;
	void	initialise();
protected:
	SpecificHeatCapacity	the_comp_cp;
	Area		the_cs_face_area;
	Mass		the_total_mass;
	Length		the_duct_length;
	Length		the_duct_hydraulic_diameter;
	Substance	the_air;

public:
	Ac_duct(Metaclass* meta, Ac_duct_def* def);
	~Ac_duct();

virtual	void		create_me(EConnection* caller);
	void		create_me(Mass_flow_rate water_rate);

	SpecificHeatCapacity	comp_cp();
	Area		cs_face_area();
	Length		duct_length();
	Length		duct_hydraulic_diameter();
	Mass		total_mass();
	Substance	air();

};

inline  SpecificHeatCapacity   Ac_duct::comp_cp()
{
	return the_comp_cp;
};

inline	Area 	Ac_duct::cs_face_area()
{
	return the_cs_face_area;
};

inline	Length	Ac_duct::duct_length()
{
	return the_duct_length;
};

inline	Length 	Ac_duct::duct_hydraulic_diameter()
{
	return the_duct_hydraulic_diameter;
};

inline	Mass	Ac_duct::total_mass()
{
	return the_total_mass;
};

inline	Substance	Ac_duct::air()
{
	return the_air;
}

#endif
