#include "Ac_duct.h"

#include "EConnection.h"
#include "Metaclass.h"
#include "math.h"
#include "list.h"
#include "Temperature.h"
#include "Speed.h"

typedef	float	Velocity;

template_define(List,State_variable);

static	char*	class_name = "the_Ac_duct";
static	char*	class_type = "Ac_duct";

static	float	initial_temp[1] = { 20 };
static	List(State_variable)*	sv_list = new List(State_variable)();

void	Ac_duct::initialise()
{
		//initialise component system equation_set.
	for(int i=0; i<the_no_of_nodes; i++) {
		State_variable*	svp = new State_variable(this, initial_temp[i]);
		sv_list->append(svp);
	}
};

/*
			1 internal function
*/

Heat_transfer_coeff	inside_htc_air(Speed va, Length hyd_dia,
				      	 Temperature ta)
{
	float hi = 0.02*(1+pow(hyd_dia.value(), 2/3)) *
			(pow(va.value(), 0.78) / pow(hyd_dia.value(), 0.22)) *
			(153 - 0.25 * ta.value());
	return hi;
};


Ac_duct::Ac_duct(Metaclass* meta, Ac_duct_def* def)
					: EComponent(meta, (EComponent_def*) def),
					the_air("air")
{
	DEBUG << "Ac_duct::Ac_duct(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_no_of_nodes = 1;

	the_comp_cp	 = def->comp_cp();
	the_cs_face_area = def->cs_face_area();
	the_total_mass = def->total_mass();
	the_duct_length= def->duct_length();
//	the_tube_diameter = def->tube_diameter();
	the_duct_hydraulic_diameter = def->duct_hydraulic_diameter();

	initialise();
};

Ac_duct::~Ac_duct()
{
	DEBUG << "Ac_duct::~Ac_duct()\n";
};

void		Ac_duct::create_me(EConnection* caller)
{
	DEBUG << "Ac_duct::create_me(EConnection* caller)\n";

	//	generate Mass_flow_rate for water and air and call
	//create_me(Mass_flow_rate air_rate);

};

void	Ac_duct::create_me(Mass_flow_rate water_rate)
{
	DEBUG << "Ac_duct::create_me(Mass_flow_rate water_rate)\n";

	List_iterator(State_variable)	state_variable(sv_list);
	Equation_iterator	ieq = equation_set().iterator();

	SpecificHeatCapacity	capacity[1];
	capacity[0] = (the_total_mass*the_comp_cp);

		//flush old equations.
	Equation*	eqp;
	while (eqp = ieq(FORWARD)) delete eqp;

		//building up component equation.
	float coefficient = 0.0 ;
	eqp = new Equation(state_variable[0], ENERGY, - coefficient, 0, 0, capacity[0]);
	equation_set().append(eqp);
};
