#ifndef AC_COIL_DEF_H
#define AC_COIL_DEF_H

#include "EComponent_def.h"
#include 	"Area.h"
#include 	"Mass.h"
#include	"Length.h"
#include	"Mass_flow_rate.h"
#include	"ThermalResistance.h"

class Ac_coil_def : public EComponent_def {
protected:
	Area		the_outside_area;
	Area		the_inside_area;
	Area		the_coil_face_area;
	Mass		the_total_mass;
	Mass		the_water_mass;
	Length		the_tube_diameter;
	ThermalResistance	the_metal_resistance;
public:
	Ac_coil_def(Metaclass* meta);
	~Ac_coil_def();

	Area		outside_area();
	Area		inside_area();
	Area		coil_face_area();
	Length		tube_diameter();
	Mass		total_mass();
	Mass		water_mass();
	ThermalResistance	metal_resistance();

static	void	description(Metaclass* meta, ostream& s);
};


inline	Area 	Ac_coil_def::outside_area()
{
	return the_outside_area;
};

inline	Area	Ac_coil_def::inside_area()
{
	return the_inside_area;
};

inline	Area 	Ac_coil_def::coil_face_area()
{
	return the_coil_face_area;
};

inline	Length	Ac_coil_def::tube_diameter()
{
	return the_tube_diameter;
};

inline	Mass	Ac_coil_def::total_mass()
{
	return the_total_mass;
};

inline	ThermalResistance	Ac_coil_def::metal_resistance()
{
	return the_metal_resistance;
};

#endif
