/*
    Generic type: AC coil
    Type	: Single component
    Description	: air heating coil fed by WCH system; 3 node model

    Node types			excitation type		connection type
    	node 1	- solid metal	 air a/o solid	    	     contact
    	node 2	- air		      air		     flow	
    	node 3	- water		     water		     flow

   Connection conditions:
   	node 1 can have >=1 contact connections to air and solid nodes.
	node 2 can have >=1 flow connections to air nodes.
	node 3 can have >=1 flow connections to water nodes.
	node 1,2,3 can be connected to nodes of boundary component of the
		same types of dimensions.
*/

#ifndef AC_COIL_H
#define AC_COIL_H

#include "EComponent.h"

#include "Ac_coil_def.h"

#include	"Substance.h"
#include	"SpecificHeatCapacity.h"
#include	"Mass_flow_rate.h"
class	Metaclass;
class	EConnection;

typedef	float	Heat_transfer_coeff;

class Ac_coil : public EComponent {
private:
	void	initialise();
protected:
	Area		the_outside_area;
	Area		the_inside_area;
	Area		the_coil_face_area;
	Mass		the_total_mass;
	Mass		the_water_mass;
	Length		the_tube_diameter;
	ThermalResistance	the_metal_resistance;

	Substance	the_water;
	Substance	the_air;
	Substance	the_metal;
public:
	Ac_coil(Metaclass* meta, Ac_coil_def* def);
	~Ac_coil();

virtual	void		create_me(EConnection* caller);
	void		create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate);

	Substance	water();
	Substance	air();
	Substance	metal();

	Area		outside_area();
	Area		inside_area();
	Area		coil_face_area();
	Length		tube_diameter();
	Mass		total_mass();
	Mass		water_mass();
	ThermalResistance	metal_resistance();
};

#endif

inline	Area 	Ac_coil::outside_area()
{
	return the_outside_area;
};

inline	Area	Ac_coil::inside_area()
{
	return the_inside_area;
};

inline	Area 	Ac_coil::coil_face_area()
{
	return the_coil_face_area;
};

inline	Length	Ac_coil::tube_diameter()
{
	return the_tube_diameter;
};

inline	Mass	Ac_coil::total_mass()
{
	return the_total_mass;
};

inline	ThermalResistance	Ac_coil::metal_resistance()
{
	return the_metal_resistance;
};

inline	Substance	Ac_coil::water()
{
	return the_water;
}

inline	Substance	Ac_coil::air()
{
	return the_air;
}

inline	Substance	Ac_coil::metal()
{
	return the_metal;
}
