#ifndef AC_BUILDING_DEF_H
#define AC_BUILDING_DEF_H

#include "EComponent_def.h"
#include "Mass.h"
#include "Volume.h"
#include "Area.h"
#include "Energy.h"
#include "ThermalConductivity.h"
#include "SpecificHeatCapacity.h"

typedef float Heat_transfer_coeff;

class Ac_building_def : public EComponent_def {
protected:
	SpecificHeatCapacity	the_wall_specific_heat;
	ThermalConductivity	the_wall_u_value;
	Mass			the_total_mass;
	Area			the_total_surface_area;
	Volume			the_space_volume;
	Heat_transfer_coeff	the_inside_heat_transfer_coeff;
	Heat_transfer_coeff	the_outside_heat_transfer_coeff;
	Energy			the_total_heat_gains;

public:
	Ac_building_def(Metaclass* meta);
	~Ac_building_def();

	SpecificHeatCapacity	wall_specific_heat();
	ThermalConductivity	wall_u_value();
	Mass			total_mass();
	Area			total_surface_area();
	Volume			space_volume();
	float			inside_heat_transfer_coeff();
	float			outside_heat_transfer_coeff();
	Energy			total_heat_gains();

static	void	description(Metaclass* meta, ostream& s);
};


inline  SpecificHeatCapacity   Ac_building_def::wall_specific_heat()
{
	return the_wall_specific_heat;
}

inline 	ThermalConductivity	Ac_building_def::wall_u_value()
{
	return the_wall_u_value;
}

inline	Mass	Ac_building_def::total_mass()
{
	return the_total_mass;
};

inline 	Area	Ac_building_def::total_surface_area()
{
	return the_total_surface_area;
}

inline 	Volume	Ac_building_def::space_volume()
{
	return the_space_volume;
}

inline	Heat_transfer_coeff	Ac_building_def::inside_heat_transfer_coeff()
{
	return the_inside_heat_transfer_coeff;
}

inline 	Heat_transfer_coeff	Ac_building_def::outside_heat_transfer_coeff()
{
	return the_outside_heat_transfer_coeff;
}

inline Energy	Ac_building_def::total_heat_gains()
{
	return the_total_heat_gains;
}

#endif
