/*
    Generic type: Various
    Type	: Single component
    Description	: Imaginary building-like plant load; node model

    node types			excitation type		connection type
	node 2  - solid	wall 	 air a/o solid		   contact    
    	node 2	- air		      air		     flow	
*/

#ifndef AC_BUILDING_H
#define AC_BUILDING_H

#include "EComponent.h"

#include "Ac_building_def.h"

#include	"Substance.h"
#include	"SpecificHeatCapacity.h"
#include	"Mass_flow_rate.h"
class	Metaclass;
class	EConnection;

typedef	float	Heat_transfer_coeff;

class Ac_building : public EComponent {
private:
	Substance	the_air;
	Substance	the_water;
	Substance	the_metal;
	int	the_no_of_nodes;
	void	initialise();
protected:
	SpecificHeatCapacity	the_comp_specific_heat;
	SpecificHeatCapacity	the_wall_specific_heat;
	ThermalConductivity	the_wall_u_value;
	Mass			the_total_mass;
	Area			the_total_surface_area;
	Volume			the_space_volume;
	Heat_transfer_coeff	the_inside_heat_transfer_coeff;
	Heat_transfer_coeff	the_outside_heat_transfer_coeff;
	Energy			the_total_heat_gains;

public:
	Ac_building(Metaclass* meta, Ac_building_def* def);
	~Ac_building();

virtual	void		create_me(EConnection* caller);
	void		create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate);

	SpecificHeatCapacity	comp_specific_heat();
	SpecificHeatCapacity	wall_specific_heat();
	ThermalConductivity	wall_u_value();
	Mass			total_mass();
	Area			total_surface_area();
	Volume			space_volume();
	Heat_transfer_coeff	inside_heat_transfer_coeff();
	Heat_transfer_coeff	outside_heat_transfer_coeff();
	Energy			total_heat_gains();
	Substance		air();

};

inline  SpecificHeatCapacity   Ac_building::comp_specific_heat()
{
	return the_comp_specific_heat;
}

inline  SpecificHeatCapacity   Ac_building::wall_specific_heat()
{
	return the_wall_specific_heat;
}

inline ThermalConductivity	Ac_building::wall_u_value()
{
	return the_wall_u_value;
}

inline	Mass	Ac_building::total_mass()
{
	return the_total_mass;
};

inline 	Area	Ac_building::total_surface_area()
{
	return the_total_surface_area;
}

inline 	Volume	Ac_building::space_volume()
{
	return the_space_volume;
}

inline	Heat_transfer_coeff	Ac_building::inside_heat_transfer_coeff()
{
	return the_inside_heat_transfer_coeff;
}

inline 	Heat_transfer_coeff	Ac_building::outside_heat_transfer_coeff()
{
	return the_outside_heat_transfer_coeff;
}

inline Energy	Ac_building::total_heat_gains()
{
	return the_total_heat_gains;
}

inline	Substance	Ac_building::air()
{
	return the_air;
}

#endif
