#include "Ac_building.h"

#include "EConnection.h"
#include "Metaclass.h"
#include "math.h"
#include "list.h"
#include "Temperature.h"
#include "Speed.h"

typedef	float	Velocity;

template_define(List,State_variable);

static	char*	class_name = "the_Ac_building";
static	char*	class_type = "Ac_building";

static	float	initial_temp[2] = { 15, 20};
static	List(State_variable)*	sv_list = new List(State_variable)();

void	Ac_building::initialise()
{
		//initialise component system equation_set.
	for(int i=0; i<the_no_of_nodes; i++) {
		State_variable*	svp = new State_variable(this, initial_temp[i]);
		sv_list->append(svp);
	}
};


Ac_building::Ac_building(Metaclass* meta, Ac_building_def* def)
					: EComponent(meta, (EComponent_def*) def),
					  the_water("water"),
					  the_air("air"),
					  the_metal("metal")
{
	DEBUG << "Ac_building::Ac_building(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_no_of_nodes = 2;

	the_wall_specific_heat 		 = def->wall_specific_heat();
	the_wall_u_value		 = def->wall_u_value();
	the_total_mass			 = def->total_mass();
	the_total_surface_area		 = def->total_surface_area();
	the_space_volume		 = def->space_volume();
	the_inside_heat_transfer_coeff 	 = def->inside_heat_transfer_coeff();
	the_outside_heat_transfer_coeff	 = def->outside_heat_transfer_coeff();
	the_total_heat_gains		 = def->total_heat_gains();

	initialise();
};

Ac_building::~Ac_building()
{
	DEBUG << "Ac_building::~Ac_building()\n";
};

void		Ac_building::create_me(EConnection* caller)
{
	DEBUG << "Ac_building::create_me(EConnection* caller)\n";

	//	generate Mass_flow_rate for water and air and call
	//create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate);

};

void		Ac_building::create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate)
{
	DEBUG << "Ac_building::create_me(Mass_flow_rate water_rate, Mass_flow_rate air_rate)\n";

	List_iterator(State_variable)	state_variable(sv_list);
	Equation_iterator	ieq = equation_set().iterator();

	SpecificHeatCapacity	capacity[2];
	capacity[0] = (total_mass() * wall_specific_heat());
	capacity[1] = (0.01) * (air().specificHeatCapacity());

	float	htcs[2];
	ThermalResistance	ri = 1 / (inside_heat_transfer_coeff()+1/(2.0*wall_u_value()));
	htcs[0] = ( total_surface_area() / ri ).value();

	ThermalResistance	ro = 1 / (outside_heat_transfer_coeff()+1/(2.0*wall_u_value())); 
	htcs[1] = ( total_surface_area() / ro ).value();
	
		//flush old equations.
	Equation*	eqp;
	while (eqp = ieq(FORWARD)) delete eqp;

		//building up 2 component equations.
		//First do solid.
	float coefficient = ( (htcs[0]) / capacity[0] ).value();
	eqp = new Equation(state_variable[0], ENERGY, - coefficient, 0, 0, capacity[0]);
	coefficient = ( htcs[0] / capacity[0] ).value();
	eqp->append_coefficient(state_variable[1], coefficient, TEMPERATURE);
	equation_set().append(eqp);

		//Now do air.
        Energy qi( total_heat_gains() );
	coefficient = ( (htcs[0] ) / capacity[1] ).value();
	eqp = new Equation(state_variable[1], ENERGY, - coefficient, qi, 0, capacity[1]);
	coefficient = ( htcs[0] / capacity[1] ).value();
	eqp->append_coefficient(state_variable[0], coefficient, TEMPERATURE);
};
