#ifndef TYPE_5_DEF_H
#define TYPE_5_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The TRNSYS type 5: Heat exchanger

	4 parameters to be input at run time:
		0) Mode	= 1 parallel flow, type 
			  2 counter flow
			  3 cross flow
			  4 constant effectiveness
		1) UA 	= overall heat transfer coefficient of exchanger (mode 1,2,3), type 
		   or epsilon = heat exchanger effectiveness (mode 4)
		2) Cph 	= specific heat of hot side fluid, type 
		3) Cpc = specific heat of cold side fluid, type 
*/

class Type_5_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	Type_5_def(Metaclass* meta);
	Type_5_def();
	~Type_5_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	Type_5_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	Type_5_def::parameter_types()
{
	return the_parameter_types;
};

#endif
