#include 	"Type_5_def.h"

#include	"Metaclass.h"
#include	<stdlib.h>
#include	<string.h>
#include	<stream.h>
#include	"Metaclass.h"
#include	"Dimension.h"

static	char*	class_name = "the_type_5_def";
/**/static	char*	class_type = "Type_5_def";

Type_5_def::Type_5_def(Metaclass* meta)  : (meta), the_parameters()
{
	DEBUG	<< "Type_5_def::Type_5_def(Metaclass* meta)\n";

	my_name = class_name;
	my_type = class_type;

	int no_of_terms = 4;

	Mixed_vector m(no_of_terms);
	the_parameter_types = (Variable_type*)malloc(no_of_terms*sizeof(Variable_type));

	cout <<"Type_5 has 4 parameters\n"
		<<"\tfor each paramater define its value\n";

	the_parameter_types[0] = ModE;
	the_parameter_types[1] = HtC;
	the_parameter_types[2] = SpecificheaT;
	the_parameter_types[3] = SpecificheaT;

	char* typename[4];
	typename[0] = ": mode (1,2,3 or 4): ";
	typename[1] = ": UA or epsilon for mode 4 (w/m^2k): ";
	typename[2] = ": hot side fluid specific heat (water 4182 j/kgk): ";
	typename[3] = ": cold side fluid specific heat (air 1005 j/kgk): ";

	float value=0;
	for(int i=0; i<4; i++) {
		cout <<"\t no " <<i+1 <<typename[i];
		cin >> value;
		m[i] = new Dimension(value);
	}
	the_parameters = m;
};

Type_5_def::Type_5_def()  : (), the_parameters()
{
	DEBUG	<< "Type_5_def::Type_5_def()\n";

	name(class_name);
	my_type = class_type;
};

Type_5_def::~Type_5_def()
{
	DEBUG	<< "Type_5_def::~Type_5_def()\n";

	delete the_parameter_types;
};

void	Type_5_def::description(Metaclass* meta, ostream& s)
{
	strcat(indent,"    ");
	s  << indent << "Type_5 : ";
	AComponent_def::description(meta, s);
	s << indent << "->  mode = \n";
	s << indent << "      UA = \n";
	s << indent << "     Cph = \n";
	s << indent << "     Cpc = \n";
	indent[strlen(indent)-4] = '\0';
};
