/*
  The TRNSYS type 5: Heat exchanger

  Inputs	- 4
  Outputs	- 6
  Parameters	- 4
  Derivatives	- 0

  the_in_vector			verbal				connection type
	[0] Thi		hot side inlet temperature  (degC)	TmeperaturE
	[1] Mh		hot side mass flow rate	    (kg/s)	MasS
	[2] Tci		cold side inlet temperature (degC)	TmeperaturE
	[3] Mc		cold side mass flow rate    (kg/s)	MasS

  the_out_vector		verbal				connection type
	[0] Tho 	hot side outlet temperature   (degC)	TmeperaturE
	[1] Mh  	hot side mass flow rate       (kg/s)	MasS
	[2] Tco		cold side outlet temperature  (degC)	TmeperaturE
	[3] Mc  	cold side mass flow rate      (kg/s)	MasS
	[4] Qt  	total heat exchange rate      (kg/s)	HtC
	[5] epsilon 	heat exchanger effectiveness  ( )	NondiM

  the_parameters		verbal				connection type
	[0] Mode	flow types			  ( )		ModE
	[1] UA		overall heat transfer coefficient (w/m^2k)	HtC
	[2] Cph 	specific heat of hot side fluid	  (j/kgk)	SpecificheaT
	[3] Cpc		specific heat of cold side fluid  (j/kgk)	SpecificheaT

*/
#ifndef TYPE_5_H
#define TYPE_5_H

#include "AComponent.h"
#include "Mixed_vector.h"
class Metaclass;
class Type_5_def;

class Type_5 : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	Type_5(Metaclass* meta, Type_5_def* def);
	~Type_5();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
