#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "Type_5.h"

#include "Metaclass.h"
#include "Type_5_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_type_5";
static	char*	class_type = "Type_5";

	// to initialise in_vector, out_vector and their types
void	Type_5::initialise()
{
	DEBUG << "void Type_5::initialise()\n";
	int in_terms = 4;
	int out_terms = 6;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Temperature(50);
	the_in_vector[1] = new Mass_flow_rate(10);
	the_in_vector[2] = new Temperature(10);
	the_in_vector[3] = new Mass_flow_rate(10);

	the_in_vector_type[0] = TemperaturE;
	the_in_vector_type[1] = MasS;
	the_in_vector_type[2] = TemperaturE;
	the_in_vector_type[3] = MasS;

	the_out_vector_type[0] = TemperaturE;
	the_out_vector_type[1] = MasS;
	the_out_vector_type[2] = TemperaturE;
	the_out_vector_type[3] = MasS;
	the_out_vector_type[4] = EnergY;
	the_out_vector_type[5] = NondiM;
}

Type_5::Type_5(Metaclass* meta, Type_5_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "Type_5::Type_5(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
	// water to water heat exchanger.
void	Type_5::create_me(EKSObject* caller)
{
	DEBUG << "Type_5::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float t_hi = (*the_in_vector[0]).value();
	float m_h = (*the_in_vector[1]).value();
	float t_ci = (*the_in_vector[2]).value();
	float m_c = (*the_in_vector[3]).value();

	float mode = (*the_parameters[0]).value();
	float ua_e = (*the_parameters[1]).value();
	float cp_h = (*the_parameters[2]).value();
	float cp_c = (*the_parameters[3]).value();

	float c_c = m_c * cp_c;
	float c_h = m_h * cp_h;
	float cmax = MAX(c_c, c_h);
	float cmin = MIN(c_c, c_h);

	float epsilon = 0, qmax=0;
	if (mode == 1) {
		epsilon = (1 - exp(-ua_e/cmin * (1+cmin/cmax))) / (1+cmin/cmax);
	} else if (mode == 2) {
		epsilon = (1 - exp(-ua_e/cmin * (1-cmin/cmax))) /
			((1 - cmin/cmax) * exp(-ua_e/cmin * (1-cmin/cmax)));
	} else if (mode == 3) {
		if (cmax == c_h) {
			float gama = 1 - exp(-ua_e/cmax);
			epsilon = 1 - exp(- gama*cmax/cmin);
		} else {
			float gama = 1 - exp(-ua_e/cmin);
			epsilon = 1 - exp(- gama*cmin/cmax) * cmax/cmin;
		}
	} else {
		if (cmax == c_h) {
			qmax = c_h * (t_hi - t_ci);
		} else {
			qmax = c_c * (t_hi - t_ci);
		}
	}

	float t_ho, t_co, q_tot;
	if (mode != 4) {
		t_ho = t_hi - epsilon * (cmin / c_h) * (t_hi - t_ci);
		t_co = t_ci + epsilon * (cmin / c_h) * (t_hi - t_ci);
		q_tot =  epsilon * cmin * (t_hi - t_ci);
	} else {
		q_tot =  epsilon * qmax;
		t_ho = t_hi - q_tot/c_h;
		t_co = t_ci + q_tot/c_c;
	}

		// encapsulate the result to outputs
	the_out_vector[0] = new Temperature(t_ho);
	the_out_vector[1] = new Mass_flow_rate(m_h);
	the_out_vector[2] = new Temperature(t_co);
	the_out_vector[3] = new Mass_flow_rate(m_c);
	the_out_vector[4] = new Energy(q_tot);
	the_out_vector[5] = new NonDimensional(epsilon);
};
