#ifndef IDEAL_PIPE_DEF_H
#define IDEAL_PIPE_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The Ideal Pipe:

	1 parameters to be input at run time:
		0) diameter (m)
*/

class Ideal_pipe_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	Ideal_pipe_def(Metaclass* meta);
	Ideal_pipe_def();
	~Ideal_pipe_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	Ideal_pipe_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	Ideal_pipe_def::parameter_types()
{
	return the_parameter_types;
};

#endif
