/*
  The Ideal Pipe: no heat loss, no friction loss

  Inputs	- 2
  Outputs	- 4
  Parameters	- 1
  Derivatives	- 0

  the_in_vector			verbal				connection type
	[0] Thi		water inlet temperature  (degC)		TmeperaturE
	[1] Mi		water mass flow rate 	 (kg/s)		MasS

  the_out_vector		verbal				connection type
	[0] Tho 	water outlet temperature   (degC)	TmeperaturE
	[1] Mh  	water mass flow rate       (kg/s)	MasS
	[2] Uo  	water velocity		   (m/s)	VelocitY
	[3] Qt  	total heat loss		   (w)		EnergY

  the_parameters		verbal				connection type
	[0] Di		diameter		   (m)		GeneraL
*/

#ifndef IDEAL_PIPE_H
#define IDEAL_PIPE_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class Ideal_pipe_def;

class Ideal_pipe : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	Ideal_pipe(Metaclass* meta, Ideal_pipe_def* def);
	~Ideal_pipe();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
