#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "Ideal_pipe.h"

#include "Metaclass.h"
#include "Ideal_pipe_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_type_5";
static	char*	class_type = "Ideal_pipe";

	// to initialise in_vector, out_vector and their types
void	Ideal_pipe::initialise()
{
	DEBUG << "void Ideal_pipe::initialise()\n";
	int in_terms = 2;
	int out_terms = 4;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Temperature(30);
	the_in_vector[1] = new Mass_flow_rate(10);

	the_in_vector_type[0] = TemperaturE;
	the_in_vector_type[1] = MasS;

	the_out_vector_type[0] = TemperaturE;
	the_out_vector_type[1] = MasS;
	the_out_vector_type[2] = VelocitY;
	the_out_vector_type[3] = EnergY;
}

Ideal_pipe::Ideal_pipe(Metaclass* meta, Ideal_pipe_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "Ideal_pipe::Ideal_pipe(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
void	Ideal_pipe::create_me(EKSObject* caller)
{
	DEBUG << "Ideal_pipe::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float t_i = (*the_in_vector[0]).value();
	float m_i = (*the_in_vector[1]).value();

	float d_i = (*the_parameters[0]).value();

	float a_i = M_PI * d_i * d_i / 4;
	float u_i = m_i / a_i / 1000;
	float q_tot = 0;

		// encode the result to outputs
	the_out_vector[0] = new Temperature(t_i);
	the_out_vector[1] = new Mass_flow_rate(m_i);
	the_out_vector[2] = new Temperature(u_i);
	the_out_vector[3] = new Energy(q_tot);

}
