#include "ASystem.h"
#include "ASystem_def.h"
#include "Metaclass.h"

//template_define(List,Component);
template_define(List,Connection);
template_define(List,AComponent);
template_define(List,AConnection);

static	char*	class_name = "the_asystem";
/**/static	char*	class_type = "ASystem";


Boolean	ASystem::isin(AComponent* ap, List_iterator(AComponent)& lst)
{
	DEBUG	<< "ASystem::isin(AComponent* ap, List_iterator(AComponent)& lst)\n";
	AComponent*	ref;

	if (lst.size() == 0) return 0;
	while (ref = lst(FORWARD))
		if (ref == ap)	return 1;	//true
	return 0;
};

ASystem::ASystem(Metaclass* meta, ASystem_def* def)
				: (meta, (System_def*) def)
{
	DEBUG	<< "ASystem::ASystem(" << meta->oid() << ", " << def->oid() << ")\n";

	char* throwaway = class_name;
	my_type = class_type;
};

ASystem::~ASystem()
{
	DEBUG << "ASystem::~ASystem()\n";
};

void	ASystem::execute()
{
	DEBUG	<< "void ASystem::execute()\n";

	List(Connection)& ln = connections();
	List_iterator(Connection)	icon_list(&ln);


	List(AComponent)*	reference_cmp_list = new List(AComponent)();
	DEBUG <<"created a reference list for component\n";
	List_iterator(AComponent) 	reference_cmp_list_iter(reference_cmp_list);

	AConnection* a_con;
	while(a_con = (AConnection*)icon_list(FORWARD)) {
		AComponent* a_cmp = (AComponent*)a_con->source();
		if (!isin(a_cmp, reference_cmp_list_iter)) {
			reference_cmp_list->append(a_cmp);
		}
		reference_cmp_list_iter(RESET);
		a_cmp = (AComponent*)a_con->target();
		if (!isin(a_cmp, reference_cmp_list_iter)) {
			reference_cmp_list->append(a_cmp);
		}
		reference_cmp_list_iter(RESET);
		a_con->connect();
	}

/*	Algorithmic system should have component based execution so that
	all gains to a component will be counted for simultaneously.

	AComponent* a_cmp;
	while(a_cmp = (AComponent*)reference_cmp_list_iter(FORWARD)) {
		List(Connection)& in_cons = in_connection_for(a_cmp);
		List_iterator(Connection) in_cons_list(in_cons);
		AConnection* a_con;
		while(a_con = (AConnection*)in_cons_list(FORWARD))
			a_con->connect();
		//constor of AComponent should call create_me to prepare outputs.
		//so when a_con->connect() calls, there are data ready.
		//remove call of create_me() in AConnection. put here.

		a_cmp->create_me(this);
	}
	reference_cmp_list_iter(RESET);
*/
};


//template_implement(List,Component);
//template_implement(List,Connection);
template_implement(List,AComponent);
template_implement(List,AConnection);
