#ifndef AROOM_DEF_H
#define AROOM_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The Room:

	1 parameters to be input at run time:
		0) UA value (w/k)
*/

class ARoom_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	ARoom_def(Metaclass* meta);
	ARoom_def();
	~ARoom_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	ARoom_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	ARoom_def::parameter_types()
{
	return the_parameter_types;
};

#endif
