/*
  The Room: Steady state room

  Inputs	- 2
  Outputs	- 1
  Parameters	- 1
  Derivatives	- 0

  the_in_vector			verbal				connection type
	[0] Ti		external air temperature (degC)		TmeperaturE
	[1] Mi		total heat gain 	 (w)		EnergY

  the_out_vector		verbal				connection type
	[0] Tho 	room air temperature   (degC)		TmeperaturE

  the_parameters		verbal				connection type
	[0] AU		total HTC UA value	   (w/k)	GeneraL
*/

#ifndef AROOM_H
#define AROOM_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class ARoom_def;

class ARoom : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	ARoom(Metaclass* meta, ARoom_def* def);
	~ARoom();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
