#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "ARoom.h"

#include "Metaclass.h"
#include "ARoom_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_ARoom";
static	char*	class_type = "ARoom";
static	float	q_t = 0;

	// to initialise in_vector, out_vector and their types
void	ARoom::initialise()
{
	DEBUG << "void ARoom::initialise()\n";
	int in_terms = 2;
	int out_terms = 1;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Temperature(20);		//degC
	the_in_vector[1] = new Energy(5.0);		//w

	the_in_vector_type[0] = TemperaturE;
	the_in_vector_type[1] = EnergY;

	the_out_vector_type[0] = TemperaturE;
}

ARoom::ARoom(Metaclass* meta, ARoom_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "ARoom::ARoom(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
void	ARoom::create_me(EKSObject* caller)
{
	DEBUG << "ARoom::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float t_a = (*the_in_vector[0]).value();
	float q_i = (*the_in_vector[1]).value();
	q_t += q_i;

	float a_u = (*the_parameters[0]).value();

	float t_r = q_i/a_u + t_a;

		// encode the result to outputs
	the_out_vector[0] = new Temperature(t_r);

}
