#ifndef ARADIATOR_DEF_H
#define ARADIATOR_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The Radiator:

	2 parameters to be input at run time:
		0) UA value (w/k)
		1) specific heat of water (j/kg k)
*/

class ARadiator_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	ARadiator_def(Metaclass* meta);
	ARadiator_def();
	~ARadiator_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	ARadiator_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	ARadiator_def::parameter_types()
{
	return the_parameter_types;
};

#endif
