#include 	"ARadiator_def.h"

#include	"Metaclass.h"
#include	<stdlib.h>
#include	<string.h>
#include	<stream.h>
#include	"Dimension.h"

static	char*	class_name = "the_ARadiator_def";
/**/static	char*	class_type = "ARadiator_def";

ARadiator_def::ARadiator_def(Metaclass* meta)  : (meta), the_parameters()
{
	DEBUG	<< "ARadiator_def::ARadiator_def(Metaclass* meta)\n";

	my_name = class_name;
	my_type = class_type;

	int no_of_terms = 2;
	Mixed_vector m(no_of_terms);
	the_parameter_types = (Variable_type*)malloc(no_of_terms*sizeof(Variable_type));

	cout <<"ARadiator has 2 parameter\n"
		<<"\tfor each paramater define its value\n";

	the_parameter_types[0] = GeneraL;
	the_parameter_types[1] = GeneraL;

	char* typename[4];
	typename[0] = " : UA value (50 w/k): ";
	typename[1] = " : water specific heat (4182 j/kgk): ";

	float value=0;
	for(int i=0; i<no_of_terms; i++) {
		cout <<"\t no " <<i+1 <<typename[i];
		cin >> value;
		m[i] = new Dimension(value);
	}
	the_parameters = m;
};

ARadiator_def::ARadiator_def()  : (), the_parameters()
{
	DEBUG	<< "ARadiator_def::ARadiator_def()\n";

	name(class_name);
	my_type = class_type;
};

ARadiator_def::~ARadiator_def()
{
	DEBUG	<< "ARadiator_def::~ARadiator_def()\n";

	delete the_parameter_types;
};

void	ARadiator_def::description(Metaclass* meta, ostream& s)
{
	strcat(indent,"    ");
	s << indent << "ARadiator : ";
	AComponent_def::description(meta, s);
	s << indent << "->  UA  = \n";
	s << indent << "    Cpw = \n";
	indent[strlen(indent)-4] = '\0';
};
