/*
  The Radiator: Steady state radiator

  Inputs	- 3
  Outputs	- 3
  Parameters	- 2
  Derivatives	- 0

  the_in_vector			verbal				connection type
	[0] Ti		water inlet temperature  (degC)		TmeperaturE
	[1] Mi		water mass flow rate 	 (kg/s)		MasS
	[2] To		water outlet temperature (degC)		TmeperaturE

  the_out_vector		verbal				connection type
	[0] Tho 	water outlet temperature   (degC)	TmeperaturE
	[1] Mo  	water mass flow rate       (kg/s)	MasS
	[2] Qo  	total heat transfer	   (w)		EnergY

  the_parameters		verbal				connection type
	[0] AU		total HTC UA value	   (w/k)	GeneraL
	[1] Cp		specific heat of water	   (j/kg k)	GeneraL
*/

#ifndef ARADIATOR_H
#define ARADIATOR_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class ARadiator_def;

class ARadiator : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	ARadiator(Metaclass* meta, ARadiator_def* def);
	~ARadiator();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
