#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "ARadiator.h"

#include "Metaclass.h"
#include "ARadiator_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_ARadiator";
static	char*	class_type = "ARadiator";

	// to initialise in_vector, out_vector and their types
void	ARadiator::initialise()
{
	DEBUG << "void ARadiator::initialise()\n";
	int in_terms = 3;
	int out_terms = 3;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Temperature(30);		//degC
	the_in_vector[1] = new Mass_flow_rate(0.05);	//kg/s
	the_in_vector[2] = new Temperature(50);		//degC

	the_in_vector_type[0] = TemperaturE;
	the_in_vector_type[1] = MasS;
	the_in_vector_type[2] = TemperaturE;

	the_out_vector_type[0] = TemperaturE;
	the_out_vector_type[1] = MasS;
	the_out_vector_type[2] = EnergY;
}

ARadiator::ARadiator(Metaclass* meta, ARadiator_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "ARadiator::ARadiator(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
void	ARadiator::create_me(EKSObject* caller)
{
	DEBUG << "ARadiator::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float t_r = (*the_in_vector[0]).value();
	float m_i = (*the_in_vector[1]).value();
	float t_i = (*the_in_vector[2]).value();

	float a_u = (*the_parameters[0]).value();
	float cap = (*the_parameters[1]).value();

	float t_o = 1/(a_u/2 + m_i*cap) * (a_u*t_r + (m_i*cap - a_u/2) * t_i);
	float q_o = m_i*cap * (t_i - t_o);

		// encode the result to outputs
	the_out_vector[0] = new Temperature(t_o);
	the_out_vector[1] = new Mass_flow_rate(m_i);
	the_out_vector[2] = new Energy(q_o);

}
