#ifndef APUMP_DEF_H
#define APUMP_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The Boiler:

	1 parameters to be input at run time:
		0) water flow rate (kg/s)
*/

class APump_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	APump_def(Metaclass* meta);
	APump_def();
	~APump_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	APump_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	APump_def::parameter_types()
{
	return the_parameter_types;
};

#endif
