#include 	"APump_def.h"

#include	"Metaclass.h"
#include	<stdlib.h>
#include	<string.h>
#include	<stream.h>
#include	"Dimension.h"

static	char*	class_name = "the_APump_def";
/**/static	char*	class_type = "APump_def";

APump_def::APump_def(Metaclass* meta)  : (meta), the_parameters()
{
	DEBUG	<< "APump_def::APump_def(Metaclass* meta)\n";

	my_name = class_name;
	my_type = class_type;

	int no_of_terms = 1;
	Mixed_vector m(no_of_terms);
	the_parameter_types = (Variable_type*)malloc(no_of_terms*sizeof(Variable_type));

	cout <<"APump has 1 parameter\n"
		<<"\tfor each paramater define its value\n";

	the_parameter_types[0] = GeneraL;

	char* typename[4];
	typename[0] = " : water flow rate (0.05 kg/s): ";

	float value=0;
	for(int i=0; i<no_of_terms; i++) {
		cout <<"\t no " <<i+1 <<typename[i];
		cin >> value;
		m[i] = new Dimension(value);
	}
	the_parameters = m;
};

APump_def::APump_def()  : (), the_parameters()
{
	DEBUG	<< "APump_def::APump_def()\n";

	name(class_name);
	my_type = class_type;
};

APump_def::~APump_def()
{
	DEBUG	<< "APump_def::~APump_def()\n";

	delete the_parameter_types;
};

void	APump_def::description(Metaclass* meta, ostream& s)
{
	strcat(indent,"    ");
	s << indent << "APump : ";
	AComponent_def::description(meta, s);
	s << indent << "->  Cpw  = \n";
	indent[strlen(indent)-4] = '\0';
};
