/*
  The Pump: Steady state pump

  Inputs	- 1
  Outputs	- 2
  Parameters	- 1
  Derivatives	- 0

  the_in_vector			verbal				connection type
	[0] Ti		water inlet temperature  (degC)		TmeperaturE

  the_out_vector		verbal				connection type
	[0] To 		water outlet temperature (degC)		TmeperaturE
	[1] Mo		water mass flow rate     (kg/s)		MasS

  the_parameters		verbal				connection type
	[0] Mo		water mass flow rate     (kg/s)		MasS
*/

#ifndef APUMP_H
#define APUMP_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class APump_def;

class APump : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	APump(Metaclass* meta, APump_def* def);
	~APump();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
